using System.Data;

namespace gov.va.med.vbecs.DAL.VAL
{	
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>12/22/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Provides means for getting divisions information from VistA via VistALink.</summary>

	#endregion

	public class Divisions
	{
		private const string DIVISION_LOOKUP_RPC_NAME = "VBECS DIVISION LOOKUP";

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/7/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4261"> 
		///		<ExpectedInput>VistALink is connected.</ExpectedInput>
		///		<ExpectedOutput>DataTable with expected data containing a list of divisions from VistA.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4262"> 
		///		<ExpectedInput>VistALink is not connected.</ExpectedInput>
		///		<ExpectedOutput>InvalidOperationException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Retrieves a list of active VistA divisions calling 
		/// corresponding VistA RPC via VistALink.
		/// </summary>
		/// <returns><see cref="DataTable"/> containing a list of active VistA divisions.</returns>
		public static DataTable GetDivisionList()
		{
			string _rpcResult = VistALink.GetRpcBroker().ExecuteRpc( VistALink.CreateRpcRequest( DIVISION_LOOKUP_RPC_NAME ) );

			return DataTransformUtility.LoadXmlStringIntoSingleDataTable( _rpcResult );
		}
	}
}
